-- Description of the coefficients

--[[
expl_mass = 2.0,
Mass of the explosive in the warhead of the munition in kilograms

other_factors = { HE1, HE2, HE3};
Coefficients of high-explosive action when hitting the ground:
HE1. – high-explosive striking effect (expl_mass *HE1)
HE2. – size of the explosion effect
HE3. – size of the explosion crater

concrete_factors = { HE1, HE2, HE3},
Coefficients of high-explosive action when hitting concrete: HE1
– high-explosive striking effect (expl_mass *HE1)
HE2 – size of the explosion effect
HE3 – size of the explosion crater

concrete_obj_factor = CP,
Coefficients of concrete-piercing effect when hitting concrete:
CP-concrete-piercing effect for concrete-piercing ammunition (expl_mass *CP)

obj_factors = { HE1, HE2 },
Coefficient of high-explosive action when hitting a ground object (equipment): HE1
– high-explosive striking effect (expl_mass *HE1)
HE2 – size of the explosion effect

cumulative_factor= SC,
SC-cumulative effect for cumulative ammunition (expl_mass *SC) cumulative_thickness
= TH
TH - the maximum thickness of the armor that the cumulative part of the demedge penetrates (in meters).
If the armor unit is more, then the cumulative damage is not applied.


Let us assume that the warhead of a conventional bomb has an explosive mass of 10 kg.

The bomb has the following coefficients:

obj_factors = {0.5, 1},
concrete_factors = {0.8, 1, 1},
other_factors = {0.9, 1, 1},
cumulative_factor = 5,
concrete_obj_factor = 3
cumulative_thickness = 0.05

then,

1. if the bomb falls into the ground, the explosive effect will be 10*0.9 = 9
2. if the bomb falls on a concrete object, then the high-explosive effect will be 10*0.8, plus in addition to this object, another 3*10 = 30 concrete-breaking striking action is transmitted
3. if the bomb hits the car, the high-explosive effect will be 10*0.5,
plus an additional 5*10=50 cumulative striking action is transferred to this object, if the armor of the car is less than 5 cm.

In order not to write large tables for each warhead, there is a function simple_warhead, which takes one parameter-the mass of the explosive. The output is a conventional warhead with a high-explosive fragmentation effect.


--]]


local raad_warhead = 
{
	mass					= 500.0,
	caliber					= 500.0,
	expl_mass      			= 500.0,
	piercing_mass        	= 500.0,		
	other_factors   		= {1.0, 2.0, 2.0 },
	concrete_factors		= {1.0, 2.0, 2.0 },
	concrete_obj_factor		= 1.0,
	obj_factors				= {1.0, 2.0 },
	cumulative_factor		= 1.0,
	cumulative_thickness	= 1.0
}


local HAFT =
{
	category		= CAT_MISSILES,
	name			= "HAFT",
	user_name		= _("Haft-8"),
	scheme			= "cruise_missile",
	class_name		= "wAmmunitionCruise",
	model			= "raad",
	mass			= 1150,
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
    --add_attributes = {"Cruise missiles"},
	
	Escort			= 0,
	Head_Type		= 5,
	sigma			= {5, 5, 5},
	M		        = 1100.0,
	H_max			= 15000.0,  --13000.0
	H_min			= -1,
	Diam			= 343.0,
	Cx_pil			= 8,
	D_max			= 548192.0, --1800000.0
	D_min			= 10000.0,
	Head_Form		= 0,
	Life_Time		= 100000,
	Nr_max			= 6,
	v_min			= 170.0,
	v_mid			= 237.5,
	Mach_max		= 0.90,
	t_b				= 0.0,
	t_acc			= 5.0,
	t_marsh			= 10000.0,
	Range_max		= 548192.0,
	H_min_t			= 500.0,
	Fi_start		= 0.35,
	Fi_rak			= 3.14152,
	Fi_excort		= 0.7,
	Fi_search		= 99.9,
	OmViz_max		= 99.9,
	X_back 			= -3.392,
	Y_back 			= 0.064,
	Z_back 			= 0.0,
	Reflection 		= 0.05,
	KillDistance 	= 0.0,
	
	warhead     = raad_warhead,
    warhead_air = raad_warhead,
		
	shape_table_data =
	{
		{
			name	 = "HAFT",
			file	 = "raad",
			life	 = 1,
			fire	 = { 0, 1},
			username = _("Haft-VIII"),
			index	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	fm = {
		mass        = 1100,  
		caliber     = 0.5,  
		cx_coeff    = {1, 0.3, 0.65, 0.018, 1.6},
		L           = 4.37,
		I           = 1500,
		Ma          = 3,	--y
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.2,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 3,
		Ma_z		= 3,
		Kw_x		= 0.05,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 10,
	},
	
	simple_seeker = {
		sensitivity     = 0,
		delay		= 0.0,
		FOV			= 0.6,
		maxW		= 500,
		opTime		= 9999,
	},
	
	cruise_autopilot = {
		delay				= 0.1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 9,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 100,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.7,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.7,
		max_start_y_vel		= 25,
		stab_vel			= 237.5,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -100,
		eng_max_thrust		= 3000,		
	},
	
	final_autopilot =		{
		delay				= 0,
		K					= 240,
		Ki					= 0.001,
		Kg					= 6,
		finsLimit			= 0.4,
		useJumpByDefault	= 1,
		J_Power_K			= 1.2,
		J_Diff_K			= 0.1,
		J_Int_K				= 0.001,
		J_Angle_K			= 0.23,
		J_FinAngle_K		= 0.38,
		J_Angle_W			= 0.4,
		hKp_err				= 100,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.7,
	},
	
	control_block ={
		seeker_activation_dist		= 7000,
		default_cruise_height		= 100,
		obj_sensor					= 1,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
	},
	
	controller = {
		boost_start	= 0.001,
		march_start = 0.8,
	},
	

	boost = {	--	air launch - no booster
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},
	
	
	march = {
		impulse			= 690,
		fuel_mass		= 283.5,
		work_time		= 9999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3000,
		thrust_Tau		= 0.0017,
	},
	
	booster_animation = {
		start_val = 0,
	},
	
	play_booster_animation = {
		val = 0,
	},
	
	
}


declare_weapon(HAFT)

declare_loadout({
    category         = CAT_MISSILES,
    CLSID            = 'DIS_GB6_HE',
    attribute        = HAFT.wsTypeOfWeapon,
    Count            = 1,
    Cx_pil           = 0.0024,
    Picture          = "haft8.png",
    displayName      = _('Haft-8' .. '-HE'),
    Weight           = HAFT.mass,
    Elements         = {{ShapeName = "raad"}},
}) 






	--[[
final_autopilot =		{
		delay				= 0,
		K					= 240,
		Ki					= 0.001,
		Kg					= 6,
		finsLimit			= 0.4,
		useJumpByDefault	= 1,
		J_Power_K			= 1.2,
		J_Diff_K			= 0.1,
		J_Int_K				= 0.001,
		J_Angle_K			= 0.23,
		J_FinAngle_K		= 0.38,
		J_Angle_W			= 0.4,
		hKp_err				= 100,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.7,
		
		
		
		delay 				= 0.1,
		K					= 60,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 2.4,
		J_Diff_K			= 0.8,
		J_Int_K				= 0,
		J_Angle_K			= 0.17,
		J_FinAngle_K		= 0.195,
		J_Angle_W			= 2.4,
		hKp_err				= 100,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.7,
	},
	
]]--
	


